// IDropSourceImpl.h: interfejs dla klasy IDropSourceImpl.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IDROPSOURCEIMPL_H__6ED143B2_4A64_11D2_BCF0_00A0C9C8E50D__INCLUDED_)
#define AFX_IDROPSOURCEIMPL_H__6ED143B2_4A64_11D2_BCF0_00A0C9C8E50D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

template <class T>
class ATL_NO_VTABLE IDropSourceImpl : public IDropSource  
{
public:
    IDropSourceImpl()
    {
	    m_bDragStarted = false;
	    m_dwButtonCancel = 0;
	    m_dwButtonDrop = 0;
    }
    virtual ~IDropSourceImpl() {}

	static void WINAPI ObjectMain(bool /* bStarting */)
    {
        // pobranie informacji z pliku win.ini
        static const TCHAR szWindows[] = _T("windows");
        static const TCHAR szDragMinDist[] = _T("DragMinDist");
        static const TCHAR szDragDelay[] = _T("DragDelay");

        nDragMinDist = ::GetProfileInt(szWindows, szDragMinDist, DD_DEFDRAGMINDIST);
        nDragDelay = ::GetProfileInt(szWindows, szDragDelay, DD_DEFDRAGDELAY);
    }

    DWORD DoDragDrop(DWORD dwEffects, LPCRECT lpRectStartDrag)
    {
        ATLTRACE2(atlTraceCOM, 0, _T("IDropSourceImpl::DoDragDrop\n"));
        T* pT = static_cast<T*>(this);

        // ustawienie prostokta i jego wraliwoci na przeciganie
	    m_bDragStarted = false;

        if (lpRectStartDrag != NULL) {
		    // ustawienie prostokta na podane parametry
		    m_rectStartDrag.CopyRect(lpRectStartDrag);
	    }
	    else {
		    // w przeciwnym wypadku uycie domylnego, pustego prostokta wok aktualnego punktu
		    CPoint ptCursor;
		    GetCursorPos(&ptCursor);
		    m_rectStartDrag.SetRect(
			    ptCursor.x, ptCursor.y, ptCursor.x, ptCursor.y);
	    }

	    if (m_rectStartDrag.IsRectNull()) {
		    // pusty prostokt decyduje o braku ptli OnBeginDrag
		    m_bDragStarted = true;
	    }
	    else if (m_rectStartDrag.IsRectEmpty()) {
		    // pusty prostokt decyduje o obszarze wok punktu startowego
		    m_rectStartDrag.InflateRect(nDragMinDist, nDragMinDist);
	    }

	    // przed wywoaniem kodu OLE naley poczeka na przeniesienie myszy
	    //  poza obszar prostokta
	    if (!OnBeginDrag(pT))
		    return DROPEFFECT_NONE;

	    // wywoanie globalnego API OLE
	    CComPtr<IDataObject> spDataObject ;
        HRESULT hr = pT->_InternalQueryInterface (IID_IDataObject, (void**) &spDataObject);
        ATLASSERT (SUCCEEDED (hr));

	    CComPtr<IDropSource> spDropSource ;
        hr = pT->_InternalQueryInterface (IID_IDropSource, (void**) &spDropSource);
        ATLASSERT (SUCCEEDED (hr));

	    DWORD dwResultEffect = DROPEFFECT_NONE;
	    ::DoDragDrop(spDataObject, spDropSource, dwEffects, &dwResultEffect);
	    return dwResultEffect;
    }

// Implementacja
public:
// IDropSource
    STDMETHOD(QueryContinueDrag)(BOOL fEscapePressed, DWORD grfKeyState)
    {
        ATLTRACE2(atlTraceCOM, 0, _T("IDropSourceImpl::QueryContinueDrag\n"));
        T* pT = static_cast<T*>(this);

	    // sprawdzenie przycisku Escape lub prawego przycisku myszy i anulowanie
	    if (fEscapePressed || (grfKeyState & m_dwButtonCancel) != 0) {
		    m_bDragStarted = false; // uniknicie niepotrzebnych ustawie wskanika
		    return DRAGDROP_S_CANCEL;
	    }

	    // sprawdzenie lewego i prawego przycisku myszy w celu zakoczenia przecigania
	    if ((grfKeyState & m_dwButtonDrop) == 0)
		    return m_bDragStarted ? DRAGDROP_S_DROP : DRAGDROP_S_CANCEL;

	    // w przeciwnym wypadku ciga kontrola...
	    return S_OK;
    }

    STDMETHOD(GiveFeedback)(DWORD)
    {
        ATLTRACE2(atlTraceCOM, 0, _T("IDropSourceImpl::GiveFeedback\n"));
        T* pT = static_cast<T*>(this);
        // nie naley zmienia kursora a do momentu rozpoczcia przecigania
        return m_bDragStarted ? DRAGDROP_S_USEDEFAULTCURSORS : S_OK;
    }

    virtual bool OnBeginDrag(CWindow* pWnd)
    {
        ATLTRACE2(atlTraceCOM, 0, _T("IDropSourceImpl::OnBeginDrag\n"));
        T* pT = static_cast<T*>(this);

	    m_bDragStarted = false;

	    // drugi przycisk przerywa operacj przecigania
	    m_dwButtonCancel = 0;
	    m_dwButtonDrop = 0;
	    if (GetKeyState(VK_LBUTTON) < 0) {
		    m_dwButtonDrop |= MK_LBUTTON;
		    m_dwButtonCancel |= MK_RBUTTON;
	    }
	    else if (GetKeyState(VK_RBUTTON) < 0) {
		    m_dwButtonDrop |= MK_RBUTTON;
		    m_dwButtonCancel |= MK_LBUTTON;
	    }

	    DWORD dwLastTick = GetTickCount();
        if (pT->m_bWndLess) {
	        HRESULT hr = pT->m_spInPlaceSite->SetCapture(TRUE);
        }
        else
            pWnd->SetCapture();

	    while (!m_bDragStarted) {
		    if (pT->m_bWndLess) {
    	        if (S_FALSE == pT->m_spInPlaceSite->GetCapture())
                    break ;
            }
            else
                if (::GetCapture() != pWnd->m_hWnd)
			        break;

		    // sprawdzenie kolejnej wiadomoci
		    MSG msg;
		    if (PeekMessage(&msg, NULL, WM_MOUSEFIRST, WM_MOUSELAST, PM_REMOVE) ||
			    PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST, PM_REMOVE)) {
			    // sprawdzenie anulowania (dowolny przycisk)
			    if (msg.message == WM_LBUTTONUP || msg.message == WM_RBUTTONUP ||
				    msg.message == WM_LBUTTONDOWN || msg.message == WM_RBUTTONDOWN)
				    break;

			    // sprawdzenie anulowania z klawiatury
			    if (msg.message == WM_KEYDOWN && msg.wParam == VK_ESCAPE)
				    break;

			    // sprawdzenie pocztku przecigania
			    m_bDragStarted = !m_rectStartDrag.PtInRect(msg.pt);
		    }

		    // pocztek przecigania po upywie okrelonego czasu
		    if (GetTickCount() - dwLastTick > nDragDelay)
			    m_bDragStarted = true;
	    }
        if (pT->m_bWndLess) {
	        HRESULT hr = pT->m_spInPlaceSite->SetCapture(FALSE);
        }
        else
            ReleaseCapture();

	    return m_bDragStarted;
    }

    CRect m_rectStartDrag;  // przeciganie rozpoczyna sipo opuszczeniu tego prostokta przez mysz
	bool m_bDragStarted;    // czy przeciganie naprawd si zaczo?
	DWORD m_dwButtonCancel; // ktry klawisz spowoduje przerwanie (wcinicie)
	DWORD m_dwButtonDrop;   // ktry klawisz spowoduje potwierdzenie (zwolnienie)

	// ustawienia suce do ustalenia pocztku przecigania
	static UINT nDragMinDist;  // minimalny dystans przecigania
	static UINT nDragDelay;    // opnienie przed pocztkiem przecigania

};

template <class T> UINT IDropSourceImpl<T>::nDragMinDist;
template <class T> UINT IDropSourceImpl<T>::nDragDelay;


#endif // !defined(AFX_IDROPSOURCEIMPL_H__6ED143B2_4A64_11D2_BCF0_00A0C9C8E50D__INCLUDED_)
